<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\servicios;
use Illuminate\Http\Request;

class serviciosController extends Controller
{
    private function quitarAcentos($cadena)
    {
        $acentos = array(
            'á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú',
            'à', 'è', 'ì', 'ò', 'ù', 'À', 'È', 'Ì', 'Ò', 'Ù',
            'ä', 'ë', 'ï', 'ö', 'ü', 'Ä', 'Ë', 'Ï', 'Ö', 'Ü',
            'â', 'ê', 'î', 'ô', 'û', 'Â', 'Ê', 'Î', 'Ô', 'Û',
            'ã', 'õ', 'ñ', 'ç', 'Ã', 'Õ', 'Ñ', 'Ç'
        );

        $sinAcentos = array(
            'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U',
            'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U',
            'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U',
            'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U',
            'a', 'o', 'n', 'c', 'A', 'O', 'N', 'C'
        );

        $cadenaSinAcentos = str_replace($acentos, $sinAcentos, $cadena);

        return $cadenaSinAcentos;
    }

    public function index(){
        $productos = servicios::select(
                                'servicios.*')
                            ->orderBy('servicios.id', 'asc')->get();
        return $productos;
    }

    public function buscar(Request $request) {
        $search = '%' . $this->quitarAcentos($request->buscar) . '%';
        $resultados = servicios::select('servicios.*')
                                ->where('servicios.imagen1', 'LIKE', $search)
                                ->orWhere('servicios.titulo', 'LIKE', $search)
                                ->orderBy('id', 'desc')
                                ->get();
        return response()->json($resultados);
    }

    public function buscar2($query) {
        $resultados = servicios::where('nombre', 'like', '%' . $query . '%')
                                ->get();
        return response()->json($resultados);
    }


    public function show($id){

        $productos = servicios::select('servicios.*')
            ->where('servicios.id', '=', $id)
        ->orderBy('servicios.id', 'asc')->get();
        return $productos;
    }


    public function store(Request $request)
    {
        $saveproducto = new servicios();

        $request->validate([
            'titulo'=>'required',
            'imagen1' =>'required',
            'imagen2' =>'required',
            'descripcion'=>'required'
        ]);
        
        $saveproducto->titulo = $request->titulo;
        $saveproducto->descripcion = $request->descripcion;

        if($request->hasFile('imagen1')){
            $file = $request->file('imagen1');
            $filename = $file->getClientOriginalName(); 
            $name_File=str_replace(" ","_", $filename);
            
            $pictureImagen1 = date('His').'-'.$name_File;
            $file->move(public_path('servicios/'),$pictureImagen1);
        }        
       
        $saveproducto->imagen1 = $pictureImagen1;

        if($request->hasFile('imagen2')){
            $file = $request->file('imagen2');
            $filename = $file->getClientOriginalName(); 
            $name_File=str_replace(" ","_", $filename);
            
            $pictureImagen2 = date('His').'-'.$name_File;
            $file->move(public_path('servicios/'),$pictureImagen2);
        }        
       
        $saveproducto->imagen2 = $pictureImagen2;

        $result = $saveproducto->save();

        if($result){
            return response()->json(['status'=>"success"]);
        }else {
            return response()->json(['status'=>"error"]);
        }
    }

    public function update(Request $request, $id)
    {
        $updateProducto= servicios::findOrFail($id);

        $request->validate([
            'titulo'=>'required',
            'imagen1' =>'required',
            'imagen2' =>'required',
            'descripcion'=>'required'
        ]);

        $updateProducto->titulo = $request->titulo;
        $updateProducto->descripcion = $request->descripcion;
        

        if($request->hasFile('imagen1')){
            $file = $request->file('imagen1');
            $filename = $file->getClientOriginalName(); 
            $name_File=str_replace(" ","_", $filename);
            
            $picture1 = date('His').'-'.$name_File;
            $file->move(public_path('servicios/'),$picture1);

            $producto = servicios::find($id);
            if ($producto->imagen1 && file_exists(public_path('servicios/' . $producto->imagen1))) {
                unlink(public_path('servicios/'.$producto -> imagen1));
            }

        }else {
            $verProducto = servicios::find($id);
            $picture1 = $verProducto['imagen1'];
        }

        $updateProducto->imagen1 = $picture1;

        if($request->hasFile('imagen2')){
            $file = $request->file('imagen2');
            $filename = $file->getClientOriginalName(); 
            $name_File=str_replace(" ","_", $filename);
            
            $picture2 = date('His').'-'.$name_File;
            $file->move(public_path('servicios/'),$picture2);

            $producto = servicios::find($id);
            if ($producto->imagen2 && file_exists(public_path('servicios/' . $producto->imagen2))) {
                unlink(public_path('servicios/'.$producto -> imagen2));
            }

        }else {
            $verProducto = servicios::find($id);
            $picture2 = $verProducto['imagen2'];
        }

        $updateProducto->imagen2 = $picture2;

        $result =$updateProducto->save();

        if($result){
            return response()->json(['status'=>"success"]);
        }else {
            return response()->json(['status'=>"error"]);
        }
    }

    public function destroy($id){
        $producto =  servicios::find($id);

        if ($producto->imagen1 && file_exists(public_path('servicios/' . $producto->imagen1))) {
            unlink(public_path('servicios/' . $producto->imagen1));
        }

        if ($producto->imagen2 && file_exists(public_path('servicios/' . $producto->imagen2))) {
            unlink(public_path('servicios/' . $producto->imagen2));
        }
        

        $result = servicios::destroy($id);

        if($result){
            return response()->json(['status'=>"success"]);
        }else {
            return response()->json(['status'=>"error"]);
        }
    }

}
