<?php

use App\Http\Controllers\Api\mailController;

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\Api\serviciosController;
use App\Http\Controllers\Api\userController;


Route::post('/login', [userController::class, 'login']);
Route::middleware('auth:sanctum')->post('logout', [userController::class, 'logout']);

//-----------------------------------------
Route::get('/oneServicio/{id}', [serviciosController::class, 'show']);
Route::get('/allServicios', [serviciosController::class, 'index']);



Route::post('/handleSuccessTransaction', [mailController::class, 'handleSuccessTransaction']);
Route::post('/oneTransaccion', [mailController::class, 'show']);
Route::get('/oneTransa/{id}', [mailController::class, 'show2']);

Route::get('/getTransaction', [mailController::class, 'show2']);

Route::post('/webhook', [mailController::class, 'handleMercadoPagoWebhook']);
Route::post('/enviarCorreo', [mailController::class, 'enviarCorreo']);


Route::group(['middleware' => ["auth:sanctum", 'role: 99']], function () {
    Route::post('/registerUsersAdmins', [userController::class, 'register']);
    Route::middleware('auth:sanctum')->get('user-profile', [userController::class, 'userProfile']);


    

    Route::controller(mailController::class)->group(function(){
        Route::post('/getTransaccion','buscar');
        Route::get('/getTransacciones','index');
        Route::put('/updateTransaccion/{id}','update');
    });

    

    Route::controller(serviciosController::class)->group(function(){
        Route::post('/saveServicio','store');
        Route::delete('/deleteServicio/{id}','destroy');
        Route::put('/updateServicio/{id}','update');
        Route::post('/getServicios','buscar');
    });

});
